function X = ist_s(y, U, N, options)

% INPUT
% y - measurement vector (time domain, dimensions M x 1)
% U - sampling scheme with increment numbers (M x 1)
% N - length of full signal

% PARAMETRES
% options.threshold ∈(0; 1) - relative to the highest peak in the spectrum with artifacts
% options.max_iter - limit of iterations

% OUTPUT
% X (frequency domain, N x 1)

%%%%%%%%%%%% parameters %%%%%%%%%%%%
if isfield(options, 'max_iter')
    max_iter = options.max_iter;
else
    max_iter = 500;
end

if isfield(options, 'threshold')
    threshold = options.threshold;
else
    threshold = 0.99;
end

%%%%%%%%%%%% initialization %%%%%%%%%%%%
y0 = zeros(N, 1);
y0(U) = y;
F = ifft(eye(N)); % inverse Fourier transform matrix
A = F(U, :); % measurement matrix: y = A*x
sp_art = A'*y; % spectrum with artifacts
t = threshold*max(abs(sp_art));
X = zeros(N, 1);
l_last = 0;
Z = setdiff(1:N, U);

%%%%%%%%%%%% main loop %%%%%%%%%%%%
for i = 1:max_iter
%     disp(horzcat('iteration', ' ', int2str(i)))
    X = delta(sp_art, t);
    fX = F*X;
    y0(Z) = fX(Z);
    sp_art = fft(y0);
    t = threshold*max(abs(sp_art));
    t = t*threshold*(max_iter - i)/max_iter;
end
X = sp_art;
end
